/*
 * CommandLineStatusIndicator.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */


#include "CommandLineStatusIndicator.hpp"

#include <iostream>

#include "Actions/Process.hpp"

using namespace std;

CommandLineStatusIndicator::CommandLineStatusIndicator()
{
  Process::AddObserver(this);
}

CommandLineStatusIndicator::~CommandLineStatusIndicator()
{
  Process::RemoveObserver(this);
}

void CommandLineStatusIndicator::update(Observable *subject){
  Process *proc;
  // we are only observing Processes
  if((proc=dynamic_cast<Process*>(subject))){
    // see what kind of progress we have to display
    if(proc->getMaxSteps()>0){
      if(!proc->doesStop()){
        cout << "Busy (" << proc->getName() << ") ";
        // we can show a percentage done
        cout << (int)proc->getDoneRatio() << "% done" << endl;
      }
    }
    else{
      // we only show some kind of busy animation
      if(proc->doesStart()){
        cout << "Busy (" << proc->getName() << ")";
      }
      if(!proc->doesStop()){
        cout << ".";
      }
      else {
        cout << endl;
      }
    }
  }
}

void CommandLineStatusIndicator::subjectKilled(Observable *subject){

}

