/*
 * CommandLineDialog.hpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

#ifndef COMMANDLINEDIALOG_HPP_
#define COMMANDLINEDIALOG_HPP_

#include <string>

#include "UIElements/Dialog.hpp"

/** CommandLineUIFactory implementation of the Dialog.
 * The idea here is that for each query the parsed command line options are used instead.
 */
class CommandLineDialog : public Dialog
{
public:
  CommandLineDialog();
  virtual ~CommandLineDialog();

  virtual void queryInt(const char *, int *);
  virtual void queryString(const char*, std::string *);
  virtual void queryDouble(const char*, double*);
  virtual void queryMolecule(const char*,molecule**,MoleculeListClass*);
  virtual void queryVector(const char*,Vector *,const double * const,bool);
  virtual void queryElement(const char*,const element **);

protected:
  // specialized stuff for text queries
  class IntTextQuery : public Dialog::IntQuery {
  public:
    IntTextQuery(std::string title, int *_target);
    virtual ~IntTextQuery();
    virtual bool handle();
  };

  class DoubleTextQuery : public Dialog::DoubleQuery {
  public:
    DoubleTextQuery(std::string title, double *_target);
    virtual ~DoubleTextQuery();
    virtual bool handle();
  };

  class StringTextQuery : public Dialog::StringQuery {
  public:
    StringTextQuery(std::string title, std::string *_target);
    virtual ~StringTextQuery();
    virtual bool handle();
  };

  class MoleculeTextQuery : public Dialog::MoleculeQuery {
  public:
    MoleculeTextQuery(std::string title, molecule **_target, MoleculeListClass *_molecules);
    virtual ~MoleculeTextQuery();
    virtual bool handle();
  };

  class VectorTextQuery : public Dialog::VectorQuery {
  public:
    VectorTextQuery(std::string title,Vector *_target,const double *const _cellSize,bool _check);
    virtual ~VectorTextQuery();
    virtual bool handle();
  };

  class ElementTextQuery : public Dialog::ElementQuery {
  public:
    ElementTextQuery(std::string title, const element **_target);
    virtual ~ElementTextQuery();
    virtual bool handle();
  };
};

#endif /* COMMANDLINEDIALOG_HPP_ */
