/*
 * LinkedCell.hpp
 *
 *  Created on: Nov 15, 2011
 *      Author: heber
 */

#ifndef LINKEDCELL_HPP_
#define LINKEDCELL_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "LinkedCell/types.hpp"

class TesselPoint;

namespace LinkedCell {

  /** This class contains a specific cell of a three-dimensional linked cell
   * mesh.
   *
   * Basically, we extend LinkedList by the triplet of indices.
   */
  class LinkedCell : public LinkedList
  {
  public:
    explicit LinkedCell(const tripleIndex &_indices);
    ~LinkedCell();

    const tripleIndex& getIndices() const;
    const LinkedCellArray::index& getIndex(const size_t index) const;

    void addPoint(const TesselPoint *point);
    void deletePoint(const TesselPoint *point);

  private:
    /** We do not allow a default constructor.
     *
     */
    LinkedCell();

    tripleIndex indices;
  };

}


#endif /* LINKEDCELL_HPP_ */
