/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2011 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * LinkedCell.cpp
 *
 *  Created on: Nov 15, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "LinkedCell/types.hpp"

#include "CodePatterns/MemDebug.hpp"

#include <algorithm>

#include "CodePatterns/Assert.hpp"
#include "LinkedCell/LinkedCell.hpp"
#include "Atom/TesselPoint.hpp"


LinkedCell::LinkedCell::LinkedCell(const tripleIndex &_indices) :
    indices(_indices)
{}

LinkedCell::LinkedCell::~LinkedCell()
{
  // prevent us from deleting any contained points
  clear();
}

const LinkedCell::tripleIndex& LinkedCell::LinkedCell::getIndices() const
{
  return indices;
}

const LinkedCell::LinkedCellArray::index& LinkedCell::LinkedCell::getIndex(const size_t index) const
{
  ASSERT((index >=0) && (index <=2),
      "LinkedCell::getIndex() - given index "+toString(index)+" is out of bounds [0,2].");
  return indices[index];
}

/** Add \a *point to this LinkedCell.
 *
 * @param point point to add
 */
void LinkedCell::LinkedCell::addPoint(const TesselPoint *point)
{
  push_back(point);
}


/** Remove \a *point from this LinkedCell.
 *
 * We do nothing if point is not found.
 *
 * @param point point to remove
 */
void LinkedCell::LinkedCell::deletePoint(const TesselPoint *point)
{
  LinkedList::iterator iter = find(begin(), end(), point);
  ASSERT( iter != end(),
      "LinkedCell::LinkedCell::deletePoint() - "+toString(*point)+" not present in this cell.");
  if (iter != end())
    erase(iter);
}
