/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * QtDialog.cpp
 *
 *  Created on: Jan 18, 2010
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "UIElements/Qt4/QtDialog.hpp"
#include "UIElements/Qt4/Query/QtQuery.hpp"

#include <QtGui/QDialogButtonBox>
#include <Qt/qpushbutton.h>
#include <Qt/qboxlayout.h>

#include "CodePatterns/MemDebug.hpp"


using namespace std;

QtDialog::QtDialog() :
    QDialog(0)
{
  // creating and filling of the Dialog window
  mainLayout = new QVBoxLayout();
  inputLayout = new QVBoxLayout();
  buttonLayout = new QVBoxLayout();
  setLayout(mainLayout);
  mainLayout->addLayout(inputLayout);
  mainLayout->addLayout(buttonLayout);
  buttons = new QDialogButtonBox(QDialogButtonBox::Ok| QDialogButtonBox::Cancel);
  buttonLayout->addWidget(buttons);

  // Disable the ok button until something was entered
  buttons->button(QDialogButtonBox::Ok)->setEnabled(false);

  // connect the buttons to their appropriate slots
  connect(buttons, SIGNAL(accepted()), this, SLOT(accept()));
  connect(buttons, SIGNAL(rejected()), this, SLOT(reject()));
}

QtDialog::~QtDialog()
{
}

bool QtDialog::display(){
  // Button state might have changed by some update that
  // was done during query construction. To make sure
  // the state is correct, we just call update one more time.
  update();
  if(exec()) {
    setAll();
    return true;
  }
  else {
    return false;
  }
}

void QtDialog::update(){
  buttons->button(QDialogButtonBox::Ok)->setEnabled(checkAll());
}

/************************** Query Infrastructure ************************/

void QtDialog::queryEmpty(const char* title, std::string)
{
  registerQuery(new EmptyQtQuery(title,inputLayout,this));
}

void QtDialog::queryBoolean(const char* title,string)
{
  registerQuery(new BooleanQtQuery(title,inputLayout,this));
}

void QtDialog::queryAtom(const char* title, std::string)
{
  registerQuery(new AtomQtQuery(title,inputLayout,this));
}

void QtDialog::queryAtoms(const char* title, std::string)
{
  registerQuery(new AtomsQtQuery(title,inputLayout,this));
}

void QtDialog::queryBox(const char* title, std::string)
{
  registerQuery(new BoxQtQuery(title,inputLayout,this));
}

void QtDialog::queryInt(const char *title,string)
{
  registerQuery(new IntQtQuery(title,inputLayout,this));
}

void QtDialog::queryInts(const char *title,string)
{
  registerQuery(new IntsQtQuery(title,inputLayout,this));
}

void QtDialog::queryDouble(const char* title,string)
{
  registerQuery(new DoubleQtQuery(title,inputLayout,this));
}

void QtDialog::queryDoubles(const char* title,string)
{
  registerQuery(new DoublesQtQuery(title,inputLayout,this));
}

void QtDialog::queryString(const char* title,string)
{
  registerQuery(new StringQtQuery(title,inputLayout,this));
}

void QtDialog::queryStrings(const char* title,string)
{
  registerQuery(new StringsQtQuery(title,inputLayout,this));
}

void QtDialog::queryMolecule(const char *title,string)
{
  registerQuery(new MoleculeQtQuery(title,inputLayout,this));
}

void QtDialog::queryMolecules(const char *title,string)
{
  registerQuery(new MoleculesQtQuery(title,inputLayout,this));
}

void QtDialog::queryVector(const char* title, bool check,string)
{
  registerQuery(new VectorQtQuery(title,check,inputLayout,this));
}

void QtDialog::queryVectors(const char* title, bool check,string)
{
  registerQuery(new VectorsQtQuery(title,check,inputLayout,this));
}

void QtDialog::queryElement(const char* title, std::string)
{
  registerQuery(new ElementQtQuery(title,inputLayout,this));
}

void QtDialog::queryElements(const char* title, std::string)
{
  registerQuery(new ElementsQtQuery(title,inputLayout,this));
}

void QtDialog::queryFile(const char* title, std::string)
{
  registerQuery(new FileQtQuery(title,inputLayout,this));
}

void QtDialog::queryRandomNumberDistribution_Parameters(const char* title, std::string)
{
  registerQuery(new RandomNumberDistribution_ParametersQtQuery(title,inputLayout,this));
}

/************************** Query Infrastructure ************************/
/*       ---> shifted to folder Query                                   */
/************************************************************************/

/*************************** Pipe Infrastructure ************************/
/*       ---> shifted to folder Pipe                                    */
/************************************************************************/
