/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * RandomNumberDistribution_ParametersQtQueryPipe.cpp
 *
 *  Created on: Jan 06, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "UIElements/Qt4/Pipe/RandomNumberDistribution_ParametersQtQueryPipe.hpp"
#include "UIElements/Qt4/QtDialog.hpp"

#include <Qt/qtextedit.h>
#include <sstream>
#include <string>

#include "CodePatterns/MemDebug.hpp"
#include "RandomNumbers/RandomNumberDistribution_Parameters.hpp"

class RandomNumberDistribution_Parameters;

RandomNumberDistribution_ParametersQtQueryPipe::RandomNumberDistribution_ParametersQtQueryPipe(const RandomNumberDistribution_Parameters *_content, QtDialog *_dialog, QTextEdit *_theBox) :
  content(_content),
  dialog(_dialog),
  theBox(_theBox)
{}

RandomNumberDistribution_ParametersQtQueryPipe::~RandomNumberDistribution_ParametersQtQueryPipe()
{}

void RandomNumberDistribution_ParametersQtQueryPipe::update() {
  QString data = theBox->toPlainText();
  std::stringstream text(data.toStdString());
  // TODO: check error
  //text >> *content;
  dialog->update();
}


