/*
 * Calculation_impl.hpp
 *
 *  Created on: Feb 19, 2010
 *      Author: crueger
 */

#ifndef CALCULATION_IMPL_HPP_
#define CALCULATION_IMPL_HPP_

#include "Actions/Calculation.hpp"

#include <cassert>

template<typename T>
Calculation<T>::Calculation(int _maxSteps, std::string _name, bool _doRegister) :
  Process(_maxSteps,_name,_doRegister),
  done(false),
  result(0)
{}

template<typename T>
Calculation<T>::~Calculation()
{
  delete result;
}

// methods inherited from Action

template<typename T>
void Calculation<T>::call(){
  reset();
  (*this)();
}

template<typename T>
void Calculation<T>::undo(){}

template<typename T>
bool Calculation<T>::canUndo()
{
  return false;
}

// methods for calculation infrastructure

template<typename T>
T Calculation<T>::operator()(){
  if(!done){
    result = doCalc();
    done = true;
  }
  return *result;
}

template<typename T>
bool Calculation<T>::hasResult(){
  return done;
}

template<typename T>
T Calculation<T>::getResult(){
  assert(done && "No result calculated");
  return *result;
}

template<typename T>
void Calculation<T>::reset(){
  done = false;
  delete result;
  result = 0;
}

#endif /* CALCULATION_IMPL_HPP_ */
