/** \file parsing.hpp
 *
 * Definitions of various class functions for the parsing of value files.
 *    
 */


#ifndef PARSING_HPP_
#define PARSING_HPP_

using namespace std;

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// ======================================= DEFINES ==========================================

#define EnergySuffix ".energy.all"
#define HcorrectionSuffix ".Hcorrection.all"
#define ForcesSuffix ".forces.all"
#define ShieldingSuffix ".sigma_all.csv"
#define ShieldingPASSuffix ".sigma_all_PAS.csv"
#define ShieldingFragmentSuffix ".sigma_all_fragment.all"
#define ShieldingPASFragmentSuffix ".sigma_all_PAS_fragment.all"
#define ChiSuffix ".chi_all.csv"
#define ChiPASSuffix ".chi_all_PAS.csv"
#define ChiFragmentSuffix ".chi_all_fragment.all"
#define ChiPASFragmentSuffix ".chi_all_PAS_fragment.all"
#define TimeSuffix ".speed"
#define EnergyFragmentSuffix ".energyfragment.all"
#define HcorrectionFragmentSuffix ".Hcorrectionfragment.all"
#define ForceFragmentSuffix ".forcefragment.all"
#define OrderSuffix ".Order"

// ======================================= FUNCTIONS ==========================================

bool FilePresent(const char *filename, bool test);
bool TestParams(int argc, char **argv);


// ======================================= CLASS MatrixContainer =============================

class MatrixContainer {
  public:
    double ***Matrix;
    int **Indices;
    char *Header;
    int MatrixCounter;
    int *RowCounter;
    int ColumnCounter;
  
  MatrixContainer();
  ~MatrixContainer();
  
  bool ParseMatrix(const char *name, int skiplines, int skipcolumns, int MatrixNr);
  virtual bool ParseFragmentMatrix(char *name, char *prefix, string suffix, int skiplines, int skipcolumns);
  bool AllocateMatrix(char *GivenHeader, int MCounter, int *RCounter, int CCounter);
  bool ResetMatrix();
  double FindMinValue();
  double FindMaxValue();
  bool SetLastMatrix(double value, int skipcolumns);
  bool SetLastMatrix(double **values, int skipcolumns);
  //bool ParseIndices();
  //bool SumSubValues();
  bool SumSubManyBodyTerms(class MatrixContainer &Matrix, class KeySetsContainer &KeySet, int Order);
  bool WriteTotalFragments(const char *name, const char *prefix);
  bool WriteLastMatrix(const char *name, const char *prefix, const char *suffix);
}; 

// ======================================= CLASS EnergyMatrix =============================

class EnergyMatrix : public MatrixContainer {
  public:
    bool ParseIndices();
    bool SumSubEnergy(class EnergyMatrix &Fragments, class EnergyMatrix *CorrectionFragments, class KeySetsContainer &KeySet, int Order, double sign);
    bool ParseFragmentMatrix(char *name, char *prefix, string suffix, int skiplines, int skipcolumns);
};

// ======================================= CLASS ForceMatrix =============================

class ForceMatrix : public MatrixContainer {
  public: 
    bool ParseIndices(char *name);
    bool SumSubForces(class ForceMatrix &Fragments, class KeySetsContainer &KeySet, int Order, double sign);
    bool ParseFragmentMatrix(char *name, char *prefix, string suffix, int skiplines, int skipcolumns);
};

// ======================================= CLASS KeySetsContainer =============================

class KeySetsContainer {
  public:
    int **KeySets;
    int *AtomCounter;
    int FragmentCounter;
    int Order;
    int *FragmentsPerOrder;
    int **OrderSet;
  
  KeySetsContainer();
  ~KeySetsContainer();
   
  bool ParseKeySets(const char *name, const int *ACounter, const int FCounter);
  bool ParseManyBodyTerms();
  bool Contains(const int GreaterSet, const int SmallerSet);
};

// ======================================= END =============================================

#endif /*PARSING_HPP_*/
